<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TeamController extends Controller
{
    public function get($id=null)
    {
        if(!is_null($id))
        {
            $data = Team::find($id);

            if($data)
            {
                return response()->json([
                    'data' => $data
                ],200);
            }else{
                return response()->json([
                    'message' => 'no record found!'
                ],404);
            }
        }
        $data = Team::select('id','name','designation','thumbnail')->where('status','active')->get();

         if($data->isNotEmpty())
            {
                return response()->json([
                    'data' => $data
                ],200);
            }else{
                return response()->json([
                    'message' => 'no record found!'
                ],404);
            }

    }

    public function store(Request $request)
    {
       $validation = Validator::make($request->all(),[
            'name' => 'required',
            'designation' => 'required',
            'details' => 'required',
            'thumbnail' => 'nullable|mimes:jpg,jpeg,png',
            'img' => 'nullable|mimes:jpg,jpeg,png',
       ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors()
            ], 422);
        }

        $team = new Team();
        $team->name = $request->name;
        $team->designation = $request->designation;
        $team->details = $request->details;

        if($request->hasFile('img')) {
            $img = $request->file('img');
            $imageName = uniqid('img').'.'.$img->getClientOriginalExtension();
            $img->move(public_path('team'), $imageName);
            $team->img= url('public/team/'.$imageName);
        }
        if($request->hasFile('thumbnail')) {
            $thumbnail = $request->file('thumbnail');
            $thumbnailName = uniqid('thumbnail').'.'.$thumbnail->getClientOriginalExtension();
            $thumbnail->move(public_path('team'), $thumbnailName);
            $team->thumbnail= url('public/team/'.$thumbnailName);
        }

        if($team->save())
        {
            return response()->json([
               'message' => 'team saved successfully'
            ],200); 
        }else{
            return response()->json([
               'message' => 'something went wrong , try again'
            ],400); 
        }

    }

    public function changeStatus(Request $request , $id)
    {
        $validation = Validator::make($request->all(),[
           'status' => 'required|in:active,inactive,deleted'
        ]);
        if($validation->failed())
        {
            return response()->json([
               'message' => 'validation failed !'
            ],422);
        }

        $team = Team::find($id);

        if($team)
        {
           $team->status = $request->status;
           if($team->save())
           {
             return response()->json([
                'message' => 'change status successfully'
             ],200);
           }else{
              return response()->json([
                'message' => 'something went wrong , try again!'
             ],400);
           }
        }else{
            return response()->json([
               'message' => 'no record found !'
            ],404);
        }
    }

    public function update(Request $request , $id)
    {
        $validation = Validator::make($request->all(),[
            'name' => 'required',
            'designation' => 'required',
            'details' => 'required',
            'thumbnail' => 'nullable|mimes:jpg,jpeg,png',
            'img' => 'nullable|mimes:jpg,jpeg,png',
        ],422);
        if($validation->failed())
        {
            return response()->json([
                 'message' => 'validation failed !'
            ],422);
        }

        $team = Team::find($id);

        if(!$team)
        {
            return response()->json([
                 'message' => 'no record found !'
            ],404);
        }

        $team->name = $request->name;
        $team->designation = $request->designation;
        $team->details = $request->details;

        if($request->hasFile('img')) {
            $img = $request->file('img');
            $imageName = uniqid('img').'.'.$img->getClientOriginalExtension();
            $img->move(public_path('team'), $imageName);
            $team->img= url('public/team/'.$imageName);
        }
        if($request->hasFile('thumbnail')) {
            $thumbnail = $request->file('thumbnail');
            $thumbnailName = uniqid('thumbnail').'.'.$thumbnail->getClientOriginalExtension();
            $thumbnail->move(public_path('team'), $thumbnailName);
            $team->thumbnail= url('public/team/'.$thumbnailName);
        }

        if($team->save())
        {
            return response()->json([
               'message' => 'record update successfully'
            ],200); 
        }else{
            return response()->json([
               'message' => 'something went wrong , try again'
            ],400); 
        }

    }



}
