<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Models\TokenMain;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TokenMainController extends Controller
{
    use ApiResponseTrait;


    public function store(Request $request)
    {

        $stored = TokenMain::insert($request->all());
        return $stored ? $this->successInsertResponse($stored) : $this->errorInsertResponse();

    }


    protected function update(Request $request)
    {

        $record = TokenMain::find($request->id);
        if (!$record)
            return $this->generalResponse('RECORD_NOT_FOUND', 404);


        $request->merge(['updated_status' => '1']);
        $record->update($request->all());

        return $record ? $this->successUpdateResponse($record) : $this->errorUpdateResponse();
    }

    protected function index(Request $request, $id = null)
    {

        $serverId = $request->server_id;
        $limit = $request->input('limit', 25);


        $data = TokenMain::whereId($id)
            ->Where('Comp_ID', COMPANY_ID)
            ->whereServerId($serverId)
            ->whereUpdateAble($request->updated_status)
            ->paginate($limit);

        return ($data->total() > 0) ? $this->recordFoundResponse($data) : $this->recordNotFoundResponse();

    }

    public function serverId()
    {

        $data = TokenMain::select('server_id as id')->Where('Comp_ID', COMPANY_ID)->get();
        return $data->isNotEmpty()
            ? $this->successResponse($data, RECORD_FOUND, HTTP_OK)
            : $this->generalResponse(RECORD_NOT_FOUND, HTTP_NOT_FOUND);
    }

    public function changeUpdatedStatus(Request $request)
    {
        $serverIds = $request->server_id;

        $execute = DB::table('token_mains')
            ->whereIn('server_id', $serverIds)
            ->update(['updated_status' => '0']);

        return $execute ? $this->successUpdateResponse($serverIds) : $this->errorUpdateResponse();
    }

    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        foreach ($request->data as $list) {
            $result = DB::table('token_mains')
                ->where('server_id', $list['server_id'])
                ->update([
                    'server_id' => $list['Token_ID'],
                    'Comp_ID' => $list['Comp_ID'],
                    'Ledger_ID' => $list['Ledger_ID'],
                    'T_Date' => $list['T_Date'],
                    'Cust_ID_REFERENCE' => $list['Cust_ID_REFERENCE'],
                    'Cust_ID' => $list['Cust_ID'],
                    'Token_Amt' => $list['Token_Amt'],
                    'Adj_Token' => $list['Adj_Token'],
                    'Valid_Date' => $list['Valid_Date'],
                    'Pay_Acco' => $list['Pay_Acco'],
                    'T_Detail' => $list['T_Detail'],
                    'Cancelled_By' => $list['Cancelled_By'],
                    'Cancel_Ledger_ID' => $list['Cancel_Ledger_ID'],
                    'Cancel_Amt' => $list['Cancel_Amt'],
                    'Cancel_Reason' => $list['Cancel_Reason'],
                    'Cancel_L_Remarks' => $list['Cancel_L_Remarks'],
                    'Receipt_Booking' => $list['Receipt_Booking'],
                    'Nomi_Name' => $list['Nomi_Name'],
                    'CNIC_No' => $list['CNIC_No'],
                    'Passport_No' => $list['Passport_No'],
                    'Son_Of' => $list['Son_Of'],
                    'Addr1' => $list['Addr1'],
                    'Mob_No' => $list['Mob_No'],
                    'Relation_Ship' => $list['Relation_Ship'],
                    'SP_ID' => $list['SP_ID'],
                    'RP_ID' => $list['RP_ID'],
                    'Affilate_ID' => $list['Affilate_ID'],
                    'Total_Price' => $list['Total_Price'],
                ]);

            if ($result !== false)
                $successCount++;

        }

        if ($successCount === $totalCount)
            return $this->successUpdateResponse("All records updated successfully.");
        else
            return $this->errorUpdateResponse("Failed to update some records.");

    }
    public function addToSql(Request $request)
    {
        $server_ids = explode(',', $request->server_id);
        $data = TokenMain::whereNotIn('server_id', $server_ids)->Where('Comp_ID', COMPANY_ID)->get();
        return $data;
    }
}
