<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $password, $cnic , $user_name;

    /**
     * Create a new message instance.
     *
     * @param $user
     * @param $password
     */
    public function __construct($user, $password ,$cnic)
    {
        $this->user = $user;
        $this->password = $password;
        $this->cnic = $cnic;
        $this->user_name = $user->Cust_Name;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = [
            'user' => $this->user,
            'password' => $this->password,
            'cnic' => $this->cnic,
            'user_name' => $this->user_name
        ];

        return $this->subject('Welcome to Canal Palms')
                    ->view('emails.welcome')
                    ->with('data', $data); //
    }
}
