<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HousingUnitPremium extends Model
{
    use HasFactory;
    protected $table = 'Housing_Unit_Premium_Tab';
    protected $guarded = [];

    // protected function scopeWhereId($query, $id)
    // {
    //     if (!is_null($id))
    //         return $query->where('housing_unit_premiums.id', $id);

    // }
    
    // protected function scopeWhereServerId($query, $serverId)
    // {
    //     if (!is_null($serverId))
    //         return $query->whereIn('housing_unit_premiums.server_id', $serverId);
        
    // }
    
    // protected function scopeWhereUpdateAble($query, $updateStatus)
    // {
    //     if (!is_null($updateStatus))
    //         return $query->where('housing_unit_premiums.updated_status', $updateStatus);

    // }

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('housing_unit_plots.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('housing_unit_plots.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('housing_unit_plots.updated_status',$updateStatus) ;
      }
    }
    protected function scopeWherePropertyType($query , $type)
    {
      if(!is_null($type))
      {
        return $query->where('housing_unit_plots.UP_Type',$type) ;
      }
    }
    // protected function scopewherePrice($query , $from, $to)
    // {
    //   if(!is_null($to))
    //   {
    //     return $query->where('housing_unit_plots.price','>=',$from)
    //     ->where('housing_unit_plots.price','<=',$to);
    //   }
    // }
    // protected function scopewhereArea($query , $width, $lenght)
    // {
    //   if(!is_null($width) || !is_null($lenght))
    //   {
    //     return $query->where('housing_unit_plots.U_W',$width)
    //     ->where('housing_unit_plots.U_L',$lenght);
    //   }
    // }
    protected function scopeWhereMin($query , $min)
    {
      if(!is_null($min))
      {
        return $query->where('housing_unit_plots.price','>=',$min);
      }
    }
    protected function scopeWhereMax($query , $max)
    {
      if(!is_null($max))
      {
        return $query->where('housing_unit_plots.price','<=',$max);
      }
    }

    protected function scopeWherePriceBetween($query, $minPrice, $maxPrice) {
      if(!is_null($minPrice) && !is_null($maxPrice))
      {
        return $query->whereBetween('housing_unit_plots.price', [$minPrice, $maxPrice]);
      }
    }

    protected function scopeWhereWidth($query , $width)
    {
      if(!is_null($width))
      {
        return $query->where('housing_unit_plots.U_W',$width);
      }
    }
    protected function scopeWhereLength($query , $length)
    {
      if(!is_null($length))
      {
        return $query->where('housing_unit_plots.U_L',$length);
      }
    }
    protected function scopeWhereMarla($query , $marla)
    {
      if(!is_null($marla))
      {
        return $query->where('housing_unit_plots.UP_Marla','<=',$marla);
      }
    }

    protected function scopeWhereCity($query , $city)
    {
      if(!is_null($city))
      {
        return $query->where('housing_projects.p_city',$city);
      }
    }

    
    protected function scopeWhereLocation($query , $location)
    {
      if(!is_null($location))
      {
        return $query->where('housing_projects.p_loc', $location);
      }
    }
   
    protected function scopeId($query , $id)
    {
      if(!is_null($id))
      {
        return $query->where('housing_unit_plots.id',$id) ;
      }
    }


    protected function scopeWhereStatus($query , $status)
    {
      if(!is_null($status))
      {
        return $query->where('housing_unit_plots.UP_Status',$status);
      }

    }


    protected function scopeWhereCategory($query , $category)
    {
      if(!is_null($category))
      {
        return $query->where('housing_unit_plots.HUC_ID',$category);
      }

    }

    protected function scopeFilterBYCategory($query , $category)
    {
      if(!is_null($category))
      {
        return $query->where('categories.huc_name', $category);
      }

    }

    protected function scopeFilterByMarla($query , $marla)
    {
      if(!is_null($marla))
      {

        return $query->whereBetween('housing_unit_plots.UP_Marla', [floor($marla), ceil($marla+0.001)]);



        // return $query->where('housing_unit_plots.UP_Marla', '>=', floor($marla))
        //   ->where('housing_unit_plots.UP_Marla', '<', ceil($marla));
      }
    }
    protected $primaryKey = 'HUP_ID';
   public function plot()
   {
     return $this->hasMany(HousingUnitPlot::class,'HUP_ID','HUP_ID');
   }


    
}