<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LedgerDetail extends Model
{
    use HasFactory;

    protected $guarded = [];
    protected $table = 'Ledger_Detail';

    public $timestamps = false;

    protected function scopeWhereId($query, $id)
    {
        if (!is_null($id))
            return $query->where('ledger_details.id', $id);

    }
    
    protected function scopeWhereServerId($query, $serverId)
    {
        if (!is_null($serverId[0]))
            return $query->whereIn('ledger_details.server_id', $serverId);
    }

    protected function scopeWhereUpdateAble($query, $updateStatus)
    {
        if (!is_null($updateStatus))
            return $query->where('ledger_details.updated_status', $updateStatus);
    }
}