<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnitBlock extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected function scopeWhereId($query , $id)
    {
        if(!is_null($id))
        {
            return $query->where('unit_blocks.id',$id) ;
        }
    }
    protected function scopeWhereServerId($query , $serverId)
    {
        if(!is_null($serverId[0]))
        {
            return $query->whereIn('unit_blocks.server_id',$serverId) ;
        }
    }
    protected function scopeWhereUpdateAble($query , $updateStatus)
    {
      if(!is_null($updateStatus))
      {
        return $query->where('unit_blocks.updated_status',$updateStatus) ;

      }
    }
}