<?php

use App\Http\Controllers\SendPdfController;
use App\Http\Controllers\TestController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/email', function () {
    return view('emails/welcome');
});

Route::get('/db-test', function () {
    try {
        DB::connection()->getPdo();
        return "Database connection is OK: " . DB::connection()->getDatabaseName();
    } catch (\Exception $e) {
        return "Database connection failed: " . $e->getMessage();
    }
});


Route::get('/upload-p', function () {
    return view('upload');
})->name('upload-p');

Route::post('/upload', [SendPdfController::class, 'upload'])->name('upload.pdf');
Route::get('/payment', [TestController::class, 'showPaymentForm'])->name('payment.form');
Route::post('/payment/initiate', [TestController::class, 'initiatePayment'])->name('payment.initiate');
Route::post('/payment/callback', [TestController::class, 'handleCallback'])->name('payment.callback');