<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Housing_Sale_Inst_Pay_Main;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class HousingSaleInstPayMain extends Controller
{
    use ApiResponseTrait;

    public function serverRecord()
    {
        $data = Housing_Sale_Inst_Pay_Main::select('Inst_ID as id')->get();
        if ($data->isEmpty()) {
            return $this->recordNotFoundResponse();
        } else {
            return $this->recordFoundResponse($data);
        }
    }
    public function store(Request $request)
    {
        try {
            $stored = Housing_Sale_Inst_Pay_Main::insert($request->all());
            if ($stored) {
                return $this->successInsertResponse($stored);
            } else {
                return $this->errorInsertResponse();
            }

        } catch (\Exception $e) {

            return response()->json(['error' => 'Something went wrong while storing data' . $e], 500);
        }
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        //  print_r($request->all());
        foreach ($request->data as $arr) {
            $result = DB::table('Housing_Sale_Inst_Pay_Main')
                ->where('Inst_ID', $arr['server_id'])
                ->update([
                    'Comp_ID' => $arr['Comp_ID'],
                    'Ledger_ID' => $arr['Ledger_ID'],
                    'I_Date' => $arr['I_Date'],
                    'Cust_ID' => $arr['Cust_ID'],
                    'Project_ID' => $arr['Project_ID'],
                    'UP_ID' => $arr['UP_ID'],
                    'Inst_Amt' => $arr['Inst_Amt'],
                    'Cancel_Status' => $arr['Cancel_Status'],
                    'PDC_ID' => $arr['PDC_ID'],
                    'HSD_ID' => $arr['HSD_ID'],
                ]);
            if ($result !== false) {
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
}
