<?php

namespace App\Http\Controllers\v1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\V1\HousingSaleInstPayMain;
use App\Http\Resources\PlotRecordResource;
use App\Models\Account;
use App\Models\Housing_Sale_Inst_Pay_Main;
use App\Models\HousingUnitPlot;
use App\Models\installment;
use App\Models\Payment;
use App\Models\SaleDeedIns;
use App\Models\SaleDeedMain;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class InstallmentController extends Controller
{
    use ApiResponseTrait;

    public function plotsRecord(Request $request)
    {
        $customerNo = auth()->user()->Cust_No;

        $data = SaleDeedMain::select(
                'Housing_Sale_Deed_Main.HSD_ID as id',
                'Housing_Sale_Deed_Main.Total_Marla as marla',
                'account.Acco_Name as plot',
                'housing_unit_plots.U_W as width',
                'housing_unit_plots.U_L as length',
                'categories.huc_name as category',
                'sub_categories.husc_name as sub_category',
                DB::raw('ROUND(Housing_Sale_Deed_Main.Total_Price, 2) as total_price'),
                DB::raw('ROUND(SUM(HSIPM.Inst_Amt), 2) as total_paid'),
                DB::raw('ROUND(CASE 
                    WHEN Housing_Sale_Deed_Main.Total_Price - SUM(HSIPM.Inst_Amt) < 0 
                    THEN 0 
                    ELSE Housing_Sale_Deed_Main.Total_Price - SUM(HSIPM.Inst_Amt) 
                    END, 2) as remaining_amount')
            )
            ->leftJoin('Housing_UnitPlot_Tab as housing_unit_plots', 'Housing_Sale_Deed_Main.UP_ID', '=', 'housing_unit_plots.UP_ID')
            ->leftJoin('Account as account', 'Housing_Sale_Deed_Main.UP_ID', '=', 'account.Acco_LID')
            ->leftJoin('Housing_Sale_Inst_Pay_Main as HSIPM', 'Housing_Sale_Deed_Main.HSD_ID', '=', 'HSIPM.HSD_ID')
            ->leftJoin('Housing_Unit_Category_Tab as categories', 'housing_unit_plots.HUC_ID', '=', 'categories.HUC_ID')
            ->leftJoin('Housing_Unit_Sub_Category_Tab as sub_categories', 'housing_unit_plots.HUSC_ID', '=', 'sub_categories.HUSC_ID')
            ->where('Housing_Sale_Deed_Main.Cust_ID', $customerNo)
            ->groupBy(
                'Housing_Sale_Deed_Main.HSD_ID',
                'account.Acco_Name',
                'Housing_Sale_Deed_Main.Total_Marla',
                'housing_unit_plots.U_W',
                'housing_unit_plots.U_L',
                'Housing_Sale_Deed_Main.Total_Price',
                'categories.huc_name',
                'sub_categories.husc_name'
            )
            ->get()
            ->map(fn($item) => $this->transformPlot($item));

        // token plots (advance payments)
        $paymentPlotIds = Payment::where('csparty_id', auth()->user()->id)
            ->where('transaction_category', 'token')
            ->pluck('plot_id');

        $tokenPlots = HousingUnitPlot::select(
                'accounts.Acco_Name as plot',
                'Housing_UnitPlot_Tab.U_W as width',
                'Housing_UnitPlot_Tab.U_L as length',
                'Housing_UnitPlot_Tab.UP_Marla as marla',
                DB::raw('(Housing_UnitPlot_Tab.UP_Marla * Housing_UnitPlot_Tab.Per_M_Rate) as total_price'),
                DB::raw('(Housing_UnitPlot_Tab.UP_Marla * Housing_UnitPlot_Tab.Per_M_Rate) - 50000 as remaining_amount'),
                DB::raw("'Sargodha' as location"),
                DB::raw('50000 as total_paid')
            )
            ->join('Account as accounts', 'Housing_UnitPlot_Tab.UP_ID', '=', 'accounts.Acco_LID')
            ->whereIn('accounts.Acco_Name', $paymentPlotIds)
            ->get()
            ->map(function ($item) {
                return [
                    'id' => 0,
                    'plot' => $item->plot,
                    'marla' => (string)($item->marla),
                    'width' => (int)$item->width,
                    'length' => (int)$item->length,
                    'location' => $item->location,
                    'total_price' => (string)($item->total_price),
                    'remaining_amount' => (string)($item->remaining_amount),
                    'total_paid' => (string)($item->total_paid),
                ];
            });

        if ($data->isNotEmpty()) {
            return response()->json([
                'success' => true,
                'data' => $data,
                'token_plots' => $tokenPlots
            ], 200);
        }

        return response()->json([
            'success' => false,
            'message' => 'no record found',
        ], 404);
    }

    /**
     * Transform plot record into response format
     */
    private function transformPlot($item)
    {
        return [
            'id' => $item->id,
            'plot' => $item->plot,
            'category' => $item->category,
            'sub_category' => $item->sub_category,
            'marla' => (string)($item->marla),
            'width' => (int)$item->width,
            'length' => (int)$item->length,
            'location' => "Sargodha",
            'total_price' => (string)($item->total_price),
            'remaining_amount' => (string)($item->remaining_amount),
            'total_paid' => (string)($item->total_paid),
        ];
    }


    public function plotInstallments(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'id field required',
            ], 422);
        }

        $saleDeedMain = SaleDeedMain::where('HSD_ID', $request->id)->where('Comp_ID', 16)->first();
        $paidInstallments = $saleDeedMain->paidInstallments;

        if (!$paidInstallments) {
            return response()->json([
                'success' => false,
                'message' => 'Sale deed not found',
            ], 404);
        }

        
        $saleDeed = SaleDeedIns::with('payment')->where('HSD_ID', '=', $request->id)->where('Comp_ID', 16)->get();

        $arr = [];
        if ($saleDeed->count() > 0) {
            foreach ($saleDeed as $key => $insDeed) {                
                $arr[] = [
                    'ID' => $insDeed->ID,
                    'HSD_ID' => $insDeed->HSD_ID,
                    'Comp_ID' => $insDeed->Comp_ID,
                    'Installments' => $insDeed->Installments,
                    'Due_Date' => isset($paidInstallments[$key]) ? $paidInstallments[$key]['I_Date'] : $insDeed->Due_Date,
                    'I_Amount' => isset($paidInstallments[$key]) ? round($paidInstallments[$key]['Inst_Amt']) : round($insDeed->I_Amount ?? 0, 2),
                    'status' => isset($paidInstallments[$key]) ? 'Paid' : 'Unpaid',
                    'UP_ID' => $saleDeedMain->UP_ID,
                    'transaction_id' => $insDeed->payment?->transaction_id,
                    'paying_date' => $insDeed->payment?->paying_date,
                ];
            }
        }

        return response()->json([
            'success' => true,
            'data' => $arr,
        ], 200);
    }

    private function convertCurrency($amount)
    {
        $url = 'https://marketdata.tradermade.com/api/v1/convert';
        $params = [
            'from' => 'PKR',
            'to' => 'USD',
            'amount' => $amount,
            'api_key' => 'l3PEOIdg-QIuyvNr2SzV'
        ];


        $response = Http::withOptions([
            'verify' => false,
        ])->get($url, $params);

        $data = $response->json();
        return ($response->successful()) ? $data['total'] : 1;
    }

    public function serverRecord()
    {
        $data = installment::select('sql_id as id')->get();
        if ($data->isEmpty()) {
            return $this->recordNotFoundResponse();
        } else {
            return $this->recordFoundResponse($data);
        }
    }

    public function store(Request $request)
    {
        try {
            $stored = installment::insert($request->all());
            if ($stored) {
                return $this->successInsertResponse($stored);
            } else {
                return $this->errorInsertResponse();
            }

        } catch (\Exception $e) {

            return response()->json(['error' => 'Something went wrong while storing data' . $e], 500);
        }
    }

    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        //  print_r($request->all());
        foreach ($request->data as $arr) {
            $result = DB::table('Housing_Sale_Deed_Ins')
                ->where('sql_id', $arr['sql_id'])
                ->update([
                    'sql_id' => $arr['sql_id'],
                    'HSD_ID' => $arr['HSD_ID'],
                    'Comp_ID' => $arr['Comp_ID'],
                    'Installments' => $arr['Installments'],
                    'Due_Date' => $arr['Due_Date'],
                    'I_Amount' => $arr['I_Amount'],

                ]);
            if ($result !== false) {
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }

    public function customerPlotsRecordV1(Request $request)
    {
        $data = SaleDeedMain::select(
            'Housing_Sale_Deed_Main.HSD_ID as id',
            'accounts.Alias_Name as plot',
            'Housing_Sale_Deed_Main.Total_Marla as marla',
            'housing_unit_plots.U_W as width',
            'housing_unit_plots.U_L as length',
            'Housing_Sale_Deed_Main.Total_Price as total_price',
            'Housing_Sale_Deed_Main.Cust_Bal as remaining_amount',
            'housing_projects.p_loc as location',
            'csparty.Cust_Name as customer',
            'Housing_Sale_Deed_Main.Created_On as date',
            DB::raw('Housing_Sale_Deed_Main.Total_Price - Housing_Sale_Deed_Main.Cust_Bal as total_paid')
        )->leftJoin('housing_unit_plots', 'Housing_Sale_Deed_Main.UP_ID', '=', 'housing_unit_plots.UP_ID')
            ->leftJoin('accounts', 'Housing_Sale_Deed_Main.UP_ID', '=', 'accounts.Acco_LID')
            ->leftJoin('housing_projects', 'housing_unit_plots.Project_ID', 'housing_projects.project_id')
            ->leftJoin('csparty', 'Housing_Sale_Deed_Main.Cust_ID', 'csparty.Cust_NO')
            ->where('housing_unit_plots.UP_Status', 'SOLD')
            ->whereCustomer($request->client_id)

            ->get();
        // dd($data);

        if (!$data->isEmpty()) {
            return response()->json([
                'success' => true,
                'data' => $data,
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'data not found!',
            ], 404);
        }
    }

    public function customerPlotsRecord(Request $request)
    {
        $data = SaleDeedMain::select(
            'Housing_Sale_Deed_Main.HSD_ID as id',
            'accounts.Alias_Name as plot',
            'Housing_Sale_Deed_Main.Total_Marla as marla',
            'housing_unit_plots.U_W as width',
            'housing_unit_plots.U_L as length',
            'Housing_Sale_Deed_Main.Total_Price as total_price',
            'Housing_Sale_Deed_Main.Cust_Bal as remaining_amount',
            'housing_projects.p_loc as location',
            'csparty.Cust_Name as customer',
            'Housing_Sale_Deed_Main.Created_On as date',
            DB::raw('Housing_Sale_Deed_Main.Total_Price - Housing_Sale_Deed_Main.Cust_Bal as total_paid')
        )->leftJoin('housing_unit_plots', 'Housing_Sale_Deed_Main.UP_ID', '=', 'housing_unit_plots.UP_ID')
            ->leftJoin('accounts', 'Housing_Sale_Deed_Main.UP_ID', '=', 'accounts.Acco_LID')
            ->leftJoin('housing_projects', 'housing_unit_plots.Project_ID', 'housing_projects.project_id')
            ->leftJoin('csparty', 'Housing_Sale_Deed_Main.Cust_ID', 'csparty.Cust_NO')
            ->where('housing_unit_plots.UP_Status', 'SOLD')
            ->whereCustomer($request->client_id)

            ->get();
        // dd($data);

        if (!$data->isEmpty()) {
            return response()->json([
                'success' => true,
                'data' => $data,
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'data not found!',
            ], 404);
        }

    }
}