<?php

namespace App\Models;

use Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Attributes\TraitAttribute;
use Carbon\Carbon;

class Payment extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'payments';

    protected $hidden = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $guarded = [];


    public function client()
    {
        return $this->belongsTo(CsParty::class, 'csparty_id', 'id');
    }

    public function scopeFilterByDueDate($query, $startDate, $endDate)
    {

        if ($startDate != null && $endDate != null) {
            $query->whereBetween('payments.due_date', [$startDate, $endDate]);
        }

        return $query;
    }

    public function scopeFilterByTransactionDate($query, $startDate, $endDate)
    {

        if ($startDate != null && $endDate != null) {
            $query->whereBetween('payments.transaction_date', [$startDate, $endDate]);
        }

        return $query;
    }


    public function scopeWhereCsParty($query, $cspartyId)
    {
        if ($cspartyId != null) {
            $query->where('payments.csparty_id', $cspartyId);
        }

        return $query;
    }


    public function scopeWherePlot($query, $plotId)
    {
        if ($plotId != null) {
            $query->where('payments.plot_id', $plotId);
        }

        return $query;
    }

    public function scopeWhereId($query, $id)
    {
        if ($id != null) {
            $query->where('payments.id', $id);
        }

        return $query;
    }

    // public function getDueDateAttribute($date)
    // {
    //     return Carbon::parse($date)->format('d F Y');
    // }


    // public function getTransactionDateAttribute($date)
    // {
    //     return Carbon::parse($date)->format('d F Y');
    // }



}