<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('housing_sale_token_main', function (Blueprint $table) {
            
            $table->primary('Token_ID');
            $table->unsignedBigInteger('Comp_ID');
            $table->unsignedBigInteger('Ledger_ID');
            $table->timestamp('T_Date');
            $table->unsignedBigInteger('Cust_ID');
            $table->bigInteger('Token_Amt');
            $table->bigInteger('Adj_Token');
            $table->timestamp('Valid_Date');
            $table->string('Pay_Acco');
            $table->string('T_Detail');
            $table->unsignedBigInteger('Cancelled_By');
            $table->unsignedBigInteger('Cancel_Ledger_ID');
            $table->integer('Cancel_Amt');
            $table->string('Cancel_Reason');
            $table->string('Cancel_L_Remarks');
            $table->smallInteger('Receipt_Booking');
            $table->string('Nomi_Name');
            $table->string('CNIC_No');
            $table->string('Passport_No');
            $table->string('Son_Of');
            $table->string('Addr1');
            $table->string('Mob_No');
            $table->string('Relation_Ship');
            $table->smallInteger('SP_ID');
            $table->smallInteger('RP_ID');
            $table->smallInteger('Affilate_ID');
            $table->integer('Total_Price');
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('housing_sale_token_main');
    }
};